const axios = require('axios');
const meta = require('../config/meta');

const WhatsAppService = {
  async responderTexto(telefono, mensaje) {
    const url = `https://graph.facebook.com/v21.0/${meta.phone_number_id}/messages`;

    const payload = {
      messaging_product: 'whatsapp',
      recipient_type: 'individual',
      to: telefono,
      type: 'text',
      text: { body: mensaje }
    };

    const headers = {
      Authorization: `Bearer ${meta.access_token}`,
      'Content-Type': 'application/json'
    };

    try {
      await axios.post(url, payload, { headers });
    } catch (error) {
      console.error('Error al enviar mensaje a WhatsApp:', error.response?.data || error.message);
    }
  }
};

module.exports = WhatsAppService;
