const axios = require('axios');
const config = require('../config/openai');

const fs = require('fs');
const path = require('path');

function logErrorToFile(error) {
  const logPath = path.join(__dirname, '../logs/error.log');
  const timestamp = new Date().toISOString();
  const mensaje = `[${timestamp}] ${error}\n`;

  fs.appendFile(logPath, mensaje, err => {
    if (err) console.error('Error al escribir log de OpenAI:', err);
  });
}


const OpenAIService = {
  async responderOpenIA(mensajeUsuario) {
    const payload = {
      model: config.model,
      messages: [
        {
          role: 'system',
          content: 'Eres Maru, perteneces a una empresa vendedora de zapatos para gatos, a los clientes diles michilover, se breve'
        },
        {
          role: 'user',
          content: mensajeUsuario
        }
      ]
    };

    try {
      const response = await axios.post('https://api.openai.com/v1/chat/completions', payload, {
        headers: {
          'Content-Type': 'application/json',
          Authorization: `Bearer ${config.api_key}`
        }
      });

      return response.data.choices[0]?.message?.content || 'No se obtuvo respuesta de OpenAI.';
    } catch (error) {
      const detalle = error.response?.data || error.message;
      const errorTexto = `Error consultando OpenAI: ${JSON.stringify(detalle)}`;
      console.error(errorTexto);
      logErrorToFile(errorTexto);
      return 'Error al conectar con OpenAI.';
    }
  }
};

module.exports = OpenAIService;
