const { responderGemini } = require('./GeminiService');
const GroqService = require('./GroqService');
const OpenAIService = require('./OpenAIService');

async function responderConPrioridad(valor, texto, negocio = null) {
  let respuesta = '';
  let fuente = '';

  try {
    if (valor === 1) {
      // Prioridad: OpenAI → Groq
      try {
        respuesta = await OpenAIService.responderOpenIA(texto, negocio);
        if (!respuesta || respuesta.toLowerCase().includes('error')) {
          throw new Error('Respuesta Groq no válida');
        }
        fuente = 'OpenAI:';
      } catch {
        respuesta = await GroqService.responderGroq(texto, negocio);
        fuente = 'Groq:';
      }

    } else if (valor === 2) {
      // Prioridad: Groq → Gemini
      try {
        respuesta = await GroqService.responderGroq(texto, negocio);
        if (!respuesta || respuesta.toLowerCase().includes('error')) {
          throw new Error('Respuesta Groq no válida');
        }
        fuente = 'Groq:';
      } catch {
        respuesta = await responderGemini(texto);
        fuente = 'Gemini:';
      }

    } else if (valor === 3) {
      // Prioridad: Gemini → OpenAI
      try {
        respuesta = await responderGemini(texto);
        if (!respuesta || respuesta.toLowerCase().includes('error')) {
          throw new Error('Respuesta Groq no válida');
        }
        fuente = 'Gemini:';
      } catch {
        respuesta = await OpenAIService.responderOpenIA(texto, negocio);
        fuente = 'OpenAI:';
      }

    } else {
      // Valor inválido
      respuesta = 'No reconozco la prioridad de IA asignada.';
      fuente = 'Sistema';
    }
  } catch (error) {
    respuesta = 'Todas las IA fallaron.';
    fuente = 'Sistema';
  }

  return { respuesta, fuente };
}

module.exports = { responderConPrioridad };
