const axios = require('axios');
const config = require('../config/groq'); // Cambiar a config específico para Groq

const fs = require('fs');
const path = require('path');

function logErrorToFile(error) {
  const logPath = path.join(__dirname, '../logs/error.log');
  const timestamp = new Date().toISOString();
  const mensaje = `[${timestamp}] ${error}\n`;

  fs.appendFile(logPath, mensaje, err => {
    if (err) console.error('Error al escribir log de Groq:', err);
  });
}

const GroqService = {
  async responderGroq(mensajeUsuario) {
    const payload = {
      model: config.model, // Por ejemplo: "meta-llama/llama-4-scout-17b-16e-instruct"
      messages: [
        {
          role: 'system',
          content: 'Eres Maru, perteneces a una empresa vendedora de zapatos para gatos, a los clientes diles michilover, se breve'
        },
        {
          role: 'user',
          content: mensajeUsuario
        }
      ]
    };

    try {
      const response = await axios.post('https://api.groq.com/openai/v1/chat/completions', payload, {
        headers: {
          'Content-Type': 'application/json',
          Authorization: `Bearer ${config.api_key}` // Tu clave Groq API
        }
      });

      return response.data.choices[0]?.message?.content || 'No se obtuvo respuesta de Groq.';
    } catch (error) {
      const detalle = error.response?.data || error.message;
      const errorTexto = `Error consultando Groq: ${JSON.stringify(detalle)}`;
      console.error(errorTexto);
      logErrorToFile(errorTexto);
      return 'Error al conectar con Groq.';
    }
  }
};

module.exports = GroqService;
