// routes/webhook.js

const express = require('express');
const router = express.Router();
const ConversacionController = require('../controllers/ConversacionController');
const meta = require('../config/meta');

// Verificación de Webhook (GET)
router.get('/webhook/whatsapp', (req, res) => {
  const verify_token = meta.webhook_token;
  const mode = req.query['hub.mode'];
  const token = req.query['hub.verify_token'];
  const challenge = req.query['hub.challenge'];

  if (mode === 'subscribe' && token === verify_token) {
    return res.status(200).send(challenge);
  } else {
    return res.sendStatus(403);
  }
});

// Recepción de mensajes (POST)
router.post('/webhook/whatsapp', async (req, res) => {
  const data = req.body;
  try {
    const mensaje =
      data?.entry?.[0]?.changes?.[0]?.value?.messages?.[0]?.text?.body ||
      data?.entry?.[0]?.changes?.[0]?.value?.messages?.[0]?.interactive?.button_reply?.id ||
      null;
    const telefono = data?.entry?.[0]?.changes?.[0]?.value?.messages?.[0]?.from || null;
    const idWA = data?.entry?.[0]?.changes?.[0]?.value?.messages?.[0]?.id || null;
    const timestamp = data?.entry?.[0]?.changes?.[0]?.value?.messages?.[0]?.timestamp || null;

    if (mensaje && telefono && idWA) {
      await ConversacionController.procesar(mensaje, idWA, timestamp, telefono);
      res.status(200).json({ success: true, message: 'Mensaje procesado' });
    } else {
      res.status(400).json({ success: false, error: 'Datos incompletos' });
    }
  } catch (error) {
    console.error('Error en webhook:', error);
    res.status(500).json({ success: false, error: 'Error interno del servidor' });
  }
});

module.exports = router;