const pool = require('../config/db');

const Session = {
  async obtenerSesionActivaPorTelefono(telefono) {
    const query = `
      SELECT * FROM sesiones_clientes
      WHERE telefono_cliente = $1 AND sesion_activa = TRUE
      ORDER BY timestamp_inicio DESC
      LIMIT 1
    `;
    const { rows } = await pool.query(query, [telefono]);
    return rows[0] || null;
  },

  async crearSesionOrquestadora(telefono) {
    const query = `
      INSERT INTO sesiones_clientes (
        telefono_cliente,
        esquema_negocio,
        nombre_negocio,
        sesion_activa
      )
      VALUES ($1, '51900000000', 'Maru Orquestadora', TRUE)
      RETURNING *;
    `;
    const { rows } = await pool.query(query, [telefono]);
    return rows[0];
  }
};

module.exports = Session;
