const pool = require('../config/db');

const Negocio = {
  async crear(data) {
    const {
      nombre_negocio,
      nombre_propietario,
      telefono_contacto,
      email_contacto,
      rubro_principal,
      tipo_plan,
      nombre_schema
    } = data;

    const query = `
      INSERT INTO public.clientes_negocios (
        nombre_negocio, nombre_propietario, telefono_contacto, email_contacto,
        rubro_principal, tipo_plan, nombre_schema
      ) VALUES ($1, $2, $3, $4, $5, $6, $7)
      RETURNING *;
    `;

    const values = [
      nombre_negocio, nombre_propietario, telefono_contacto, email_contacto,
      rubro_principal, tipo_plan, nombre_schema
    ];

    const { rows } = await pool.query(query, values);
    return rows[0];
  },

  async obtenerTodos() {
    const { rows } = await pool.query('SELECT * FROM public.clientes_negocios');
    return rows;
  },

  async obtenerPorTelefonoDeNegocio(telefono) {
    const query = 'SELECT * FROM public.clientes_negocios WHERE id_cliente = $1';
    const { rows } = await pool.query(query, [telefono]);
    return rows[0] || null;
  },

  async actualizarTokens(telefono, tokens) {
    const query = `
      UPDATE public.clientes_negocios
      SET tokens_acumulados_mes = tokens_acumulados_mes + $1
      WHERE telefono_contacto = $2
      RETURNING *;
    `;
    const { rows } = await pool.query(query, [tokens, telefono]);
    return rows[0] || null;
  },

  async eliminarPorTelefono(telefono) {
    const query = `
      DELETE FROM public.clientes_negocios
      WHERE telefono_contacto = $1
      RETURNING *;
    `;
    const { rows } = await pool.query(query, [telefono]);
    return rows[0] || null;
  }
};

module.exports = Negocio;
