const pool = require('../config/db');

const Conversacion = {
  async guardar(telefono, tipo, mensaje, id_wa, timestamp) {
    
    const id_cliente = telefono.startsWith('51') ? telefono.slice(2) : telefono;

    const query = `
      INSERT INTO conversaciones_globales (
        id_cliente, numero_usuario, tipo_mensaje, mensaje, id_wa, fecha_conversacion
      ) VALUES ($1, $2, $3, $4, $5, to_timestamp($6))
    `;

    const values = [
      id_cliente,         // $1
      telefono,           // $2
      tipo,               // $3
      mensaje,            // $4
      id_wa || 'MARU',    // $5
      parseInt(timestamp) // $6
      
    ];
    try {
      await pool.query(query, values);
    } catch (err) {
      console.error('Error al guardar conversación:', err.message);
    }
  }
};

module.exports = Conversacion;
