// models/configIA.js
const { Pool } = require('pg');
const pool = new Pool(); // Usa la configuración de conexión desde .env

async function obtenerConfigIA(proveedor) {
  const valoresPorDefecto = {
    temperature: 0.7,
    max_tokens: 1024
  };

  try {
    const resultado = await pool.query(`
      SELECT temperature, max_tokens 
      FROM config_ia 
      WHERE proveedor = $1 
      LIMIT 1
    `, [proveedor]);

    if (resultado.rows.length > 0) {
      const { temperature, max_tokens } = resultado.rows[0];
      return {
        temperature: parseFloat(temperature ?? valoresPorDefecto.temperature),
        max_tokens: parseInt(max_tokens ?? valoresPorDefecto.max_tokens, 10)
      };
    } else {
      return valoresPorDefecto;
    }
  } catch (error) {
    console.warn('Error al obtener configuración IA:', error.message);
    return valoresPorDefecto;
  }
}

module.exports = { obtenerConfigIA };