const Session = require('../models/Session');

const SessionController = {

    async obtenerSesionActivaPorTelefono(telefono) {
      try {
        return await Session.obtenerSesionActivaPorTelefono(telefono);
      } catch (error) {
        console.error(`[SessionController] Error al obtener sesión para ${telefono}:`, error.message);
        return null;
      }
    },


  async obtenerSesion(req, res) {
    try {
      const sesion = await Session.obtenerSesionActivaPorTelefono(req.params.telefono);
      if (!sesion) return res.status(404).json({ error: 'Sesión no encontrada' });
      res.status(200).json(sesion);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al obtener la sesión' });
    }
  },

  async crearSesionOrquestadora(req, res) {
    try {
      const sesion = await Session.crearSesionOrquestadora(req.params.telefono);
      res.status(201).json(sesion);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al crear la sesión orquestadora' });
    }
  }
};

module.exports = SessionController;
