const Negocio = require('../models/Negocio');

const NegocioController = {

  async obtenerNegocioPorTelefonoInterno(telefono) {
    try {
      return await Negocio.obtenerPorTelefonoDeNegocio(telefono); // ← modelo correcto
    } catch (error) {
      console.error(`[NegocioController] Error al obtener negocio:`, error.message);
      return null;
    }
  },

  async crearNegocio(req, res) {
    try {
      const negocio = await Negocio.crear(req.body);
      res.status(201).json(negocio);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al crear el negocio' });
    }
  },

  async obtenerNegocios(req, res) {
    try {
      const negocios = await Negocio.obtenerTodos();
      res.status(200).json(negocios);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al obtener negocios' });
    }
  },

  async obtenerNegocioPorTelefono(req, res) {
    try {
      const negocio = await Negocio.obtenerPorTelefono(req.params.telefono);
      if (!negocio) return res.status(404).json({ error: 'Negocio no encontrado' });
      res.status(200).json(negocio);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al obtener el negocio' });
    }
  },

  async actualizarTokens(req, res) {
    try {
      const negocio = await Negocio.actualizarTokens(req.params.telefono, req.body.tokens);
      if (!negocio) return res.status(404).json({ error: 'Negocio no encontrado' });
      res.status(200).json(negocio);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al actualizar tokens' });
    }
  },

  async eliminarNegocio(req, res) {
    try {
      const eliminado = await Negocio.eliminarPorTelefono(req.params.telefono);
      if (!eliminado) return res.status(404).json({ error: 'Negocio no encontrado' });
      res.status(200).json({ mensaje: 'Negocio eliminado correctamente' });
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: 'Error al eliminar el negocio' });
    }
  }
};

module.exports = NegocioController;
