const meta = require('../config/meta');
const WhatsAppService = require('../services/whatsapp');
const RespuestaHelper = require('../helpers/RespuestaHelper');
const OpenAIService = require('../services/OpenAIService.js');
const Conversacion = require('../models/Conversacion.js'); 
const redis = require('../config/redis'); 

const { responderConGemini } = require('../services/GeminiService');

const ConversacionController = {
  async procesar(mensaje, idWA, timestamp, telefono) {
    if (!meta.usuarios_autorizados.includes(telefono)) {
      await WhatsAppService.responderTexto(telefono, 'Lo sentimos, solo respondemos a clientes autorizados.');
      return;
    }

    await Conversacion.guardar(telefono, 'recibido', mensaje, idWA, timestamp);

    const key = `buffer:${telefono}`;
    const buffer = await redis.get(key);

    let mensajes = [];
    if (buffer) {
      mensajes = JSON.parse(buffer).mensajes || [];
    }

    mensajes.push({
      mensaje,
      timestamp: Date.now()
    });

    // Guardar el nuevo buffer con TTL de 10 segundos (renueva si llega otro mensaje)
    await redis.set(key, JSON.stringify({ mensajes }));
  }
};

module.exports = ConversacionController;
